<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listagem de Arquivos</title>
</head>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Arial', sans-serif;
            background-image: url('http://7system.com.br/img/cloud2.jpg'); /* Substitua 'sua_imagem_de_nuvem.jpg' pelo caminho da sua imagem de nuvem */
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            background-color: rgba(255, 255, 255, 0.5); /* Opacidade de 50% - ajuste conforme necessário */
            height: 100vh;    
        }
    </style>
<body>
<center>
<button onclick="window.location.href='/pag/botoes.php'">Voltar</button>
<h1>RPACS - FULL RX-US</h1>
</center>

    <h2>Listagem de Arquivos</h2>

    <?php
    $caminho_pasta = '/media/fullrx';

    // Verifica se o caminho da pasta é válido
    if (is_dir($caminho_pasta)) {
        
        // Obtém a lista de arquivos na pasta com informações de data e hora
        $arquivos_info = [];
        $arquivos = scandir($caminho_pasta);
        
        // Remove os diretórios '.' e '..' e filtra apenas arquivos (excluindo subdiretórios)
        $arquivos = array_filter($arquivos, function ($arquivo) use ($caminho_pasta) {
            return is_file($caminho_pasta . '/' . $arquivo);
        });
        
        foreach ($arquivos as $arquivo) {
            $caminho_arquivo = $caminho_pasta . '/' . $arquivo;
            $arquivos_info[$arquivo] = [
                'nome' => $arquivo,
                'data_modificacao' => date("Y-m-d H:i:s", filemtime($caminho_arquivo)),
            ];
        }

        // Ordena os arquivos com base no tempo desde a modificação
        usort($arquivos_info, function($a, $b) {
            return strtotime($b['data_modificacao']) - strtotime($a['data_modificacao']);
        });

        // Armazenar o primeiro arquivo e o tempo desde a modificação em uma variável
        $primeiro_arquivo = reset($arquivos_info);
        $tempo_total_primeiro_arquivo = calcularTempoTotalDesdeModificacao($primeiro_arquivo['data_modificacao']);

        echo "<h3>1A = $tempo_total_primeiro_arquivo minutos - Status:" . getStatus($tempo_total_primeiro_arquivo) . "</h3>";

        // Caixa de pesquisa
        echo '<form action="" method="post">';
        echo '<label for="search">Procurar arquivos:</label>';
        echo '<input type="text" name="search" id="search">';
        echo '<input type="submit" value="Procurar">';
        echo '</form>';

        // Lógica de pesquisa e listagem de todos os arquivos com data, hora e tempo desde a modificação
        echo '<h3>Listagem de todos os arquivos:</h3>';
        echo '<table border="1">';
        echo '<tr><th>Nome do Arquivo</th><th>Data de Modificação</th><th>Tempo desde a Modificação</th><th>Status</th></tr>';
        foreach ($arquivos_info as $info) {
            echo "<tr>";
            echo "<td>{$info['nome']}</td>";
            echo "<td>{$info['data_modificacao']}</td>";
            echo "<td>" . calcularTempoDesdeModificacao($info['data_modificacao']) . " minutos</td>";
            echo "<td>" . getStatus(calcularTempoDesdeModificacao($info['data_modificacao'])) . "</td>";
            echo "</tr>";
        }
        echo '</table>';
        
    } else {
        echo "<p>O caminho da pasta não é válido.</p>";
    }

    function calcularTempoTotalDesdeModificacao($data_modificacao) {
        $data_atual = new DateTime();
        $data_modificacao = new DateTime($data_modificacao);
        $intervalo = $data_atual->diff($data_modificacao);
        return $intervalo->days * 24 * 60 + $intervalo->h * 60 + $intervalo->i;
    }

    function getStatus($tempo_total) {
        return ($tempo_total < 21) ? 'BOM' : 'RUIM';
    }
    ?>

</body>
</html>
