<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$servername = "149.56.34.221";
$username = "inventario";
$password = "Inventario@2024";
$dbname = "ozpet_campo_limpo_dev";

$conn = new mysqli($servername, $username, $password, $dbname);

// Verifica a conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['auditor_id'])) {
        $auditor_id = intval($_POST['auditor_id']);
        
        // Buscar o nome do auditor pelo ID
        $auditorQuery = "SELECT nome FROM funcionarios WHERE id = ?";
        $stmt = $conn->prepare($auditorQuery);
        $stmt->bind_param("i", $auditor_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $auditor = $result->fetch_assoc();
            $_SESSION['auditor'] = $auditor['nome'];
            header("Location: index.php");
            exit;
        } else {
            $error_message = "ID de auditor inválido.";
        }
        
        $stmt->close();
    } else {
        $error_message = "Por favor, selecione um auditor.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="styles.css">
    <title>Definir Auditor</title>
</head>
<body>
    <header>
        <h1>Definir Auditor</h1>
    </header>
    <main>
        <?php if (!empty($error_message)): ?>
            <p class="p.error"><?php echo $error_message; ?></p>
        <?php endif; ?>
        <form method="POST" action="">
            <label for="auditor_id">Selecione o Auditor:</label>
            <select id="auditor_id" name="auditor_id">
                <?php
                // Buscar todos os auditores disponíveis
                $auditorsQuery = "SELECT id, nome FROM funcionarios";
                $result = $conn->query($auditorsQuery);

                if ($result->num_rows > 0):
                    while ($row = $result->fetch_assoc()):
                ?>
                    <option value="<?php echo $row['id']; ?>"><?php echo $row['nome']; ?></option>
                <?php
                    endwhile;
                else:
                ?>
                    <option value="">Nenhum auditor encontrado</option>
                <?php endif; ?>
            </select>
            <button type="submit">Iniciar Sessão</button>
        </form>
    </main>
</body>
</html>
